/*
 * Decompiled with CFR 0.152.
 */
package catserver.server;

import catserver.server.CatServer;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.chunkio.ChunkIOExecutor;
import org.bukkit.craftbukkit.v1_12_R1.util.Waitable;

public class AsyncCatcher {
    public static boolean isMainThread() {
        return Thread.currentThread() == MinecraftServer.getServerInst().primaryThread;
    }

    public static boolean checkAsync(String reason) {
        if (org.spigotmc.AsyncCatcher.enabled && !AsyncCatcher.isMainThread()) {
            if (!CatServer.getConfig().disableAsyncCatchWarn) {
                CatServer.log.warn("A Mod/Plugin try to async " + reason + ", it will be executed safely on the main server thread until return!");
                CatServer.log.warn("Please check the stacktrace in debug.log and report the author.");
            }
            CatServer.log.debug("Try to async " + reason, new Throwable());
            return true;
        }
        return false;
    }

    public static void ensureExecuteOnPrimaryThread(Runnable runnable) {
        AsyncCatcher.ensureExecuteOnPrimaryThread(() -> {
            runnable.run();
            return null;
        });
    }

    public static <T> T ensureExecuteOnPrimaryThread(final Supplier<T> runnable) {
        Waitable waitable = new Waitable<T>(){

            @Override
            protected T evaluate() {
                return runnable.get();
            }
        };
        MinecraftServer.getServerInst().processQueue.add(waitable);
        try {
            return waitable.get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean checkAndPostPrimaryThread(String reason, Runnable runnable) {
        if (AsyncCatcher.checkAsync(reason)) {
            MinecraftServer.getServerInst().processQueue.add(runnable);
            return true;
        }
        return false;
    }

    public static axw asyncLoadChunkCaught(amu world, aye loader, final on provider, final int x, final int z) {
        if (ForgeChunkManager.asyncChunkLoading) {
            Waitable<axw> waitable = new Waitable<axw>(){

                @Override
                protected axw evaluate() {
                    return provider.getChunkIfLoaded(x, z);
                }
            };
            ChunkIOExecutor.queueChunkLoad(world, loader, provider, x, z, waitable);
            try {
                return (axw)waitable.get();
            }
            catch (InterruptedException | ExecutionException e) {
                throw new RuntimeException(e);
            }
        }
        return AsyncCatcher.ensureExecuteOnPrimaryThread(() -> ChunkIOExecutor.syncChunkLoad(world, loader, provider, x, z));
    }
}

